/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap.JICP;

import jade.imtp.leap.ICPException;
import jade.imtp.leap.JICP.Connection;
import jade.imtp.leap.JICP.ConnectionFactory;
import jade.imtp.leap.JICP.ConnectionWrapper;
import jade.imtp.leap.TransportProtocol;
import jade.imtp.leap.http.HTTPProtocol;
import jade.mtp.TransportAddress;
import jade.util.leap.ArrayList;
import jade.util.leap.HashMap;
import jade.util.leap.Iterator;
import jade.util.leap.List;
import java.io.IOException;

class ConnectionPool {
    private HashMap connections = new HashMap();
    private TransportProtocol myProtocol;
    private ConnectionFactory myFactory;
    private int maxSize;
    private int size;
    private boolean closed = false;

    ConnectionPool(TransportProtocol p, ConnectionFactory f, int ms) {
        this.myProtocol = p;
        this.myFactory = f;
        this.maxSize = this.myProtocol instanceof HTTPProtocol ? 0 : ms;
        this.size = 0;
    }

    synchronized ConnectionWrapper acquire(TransportAddress ta) throws ICPException {
        if (!this.closed) {
            ConnectionWrapper cw = null;
            String url = this.myProtocol.addrToString(ta);
            List l = (List)this.connections.get(url);
            if (l == null) {
                l = new ArrayList();
                this.connections.put(url, l);
            }
            Iterator it = l.iterator();
            while (it.hasNext()) {
                cw = (ConnectionWrapper)it.next();
                if (!cw.lock()) continue;
                cw.setReused();
                return cw;
            }
            try {
                Connection c = this.myFactory.createConnection(ta);
                if (this.size < this.maxSize) {
                    cw = new ConnectionWrapper(c);
                    l.add(cw);
                    ++this.size;
                } else {
                    cw = new ConnectionWrapper(c);
                    cw.setOneShot();
                }
                return cw;
            }
            catch (IOException ioe) {
                throw new ICPException("Error creating connection. ", ioe);
            }
        }
        throw new ICPException("Pool closed");
    }

    synchronized void release(ConnectionWrapper cw) {
        cw.unlock();
    }

    synchronized void remove(TransportAddress ta, ConnectionWrapper cw) {
        try {
            String url = this.myProtocol.addrToString(ta);
            List l = (List)this.connections.get(url);
            if (l != null && l.remove(cw)) {
                --this.size;
            }
            cw.getConnection().close();
        }
        catch (Exception e) {}
    }

    synchronized void shutdown() {
        Iterator it = this.connections.values().iterator();
        while (it.hasNext()) {
            List l = (List)it.next();
            int i = 0;
            while (i < l.size()) {
                ConnectionWrapper cw = (ConnectionWrapper)l.get(i);
                cw.close();
                ++i;
            }
            l.clear();
        }
        this.connections.clear();
        this.closed = true;
    }
}

